/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.lazrslib.client.font;

import com.lazrproductions.lazrslib.client.screen.ScreenUtilities;
import com.lazrproductions.lazrslib.client.screen.base.BlitCoordinates;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class FontUtilities {
    public static void renderLabel(Minecraft instance, GuiGraphics graphics, int x, int y, List<Component> list, int color, boolean renderShadow) {
        String text;
        int i;
        int space = 15;
        int width = 0;
        for (i = 0; i < list.size(); ++i) {
            text = list.get(i).getString();
            width = Math.max(width, instance.f_91062_.m_92895_(text) + 10);
        }
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        for (i = 0; i < list.size(); ++i) {
            text = list.get(i).getString();
            graphics.m_280056_(instance.f_91062_, text, x - instance.f_91062_.m_92895_(text) / 2, y + (list.size() / 2 * space + space * i), color, renderShadow);
        }
        RenderSystem.enableDepthTest();
    }

    public static void renderLabel(Minecraft instance, GuiGraphics graphics, int x, int y, List<Component> list, int color) {
        FontUtilities.renderLabel(instance, graphics, x, y, list, color, true);
    }

    public static int drawParagraph(Minecraft instance, GuiGraphics graphics, int x, int y, List<Component> list, int maxWidth, int color, boolean renderShadow) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        FormattedText text = FormattedText.m_130768_(list);
        for (FormattedCharSequence formattedcharsequence : instance.f_91062_.m_92923_(text, maxWidth)) {
            graphics.m_280649_(instance.f_91062_, formattedcharsequence, x, y, color, renderShadow);
            y += 9;
        }
        RenderSystem.enableDepthTest();
        return instance.f_91062_.m_239133_(text, maxWidth);
    }

    public static int drawParagraph(Minecraft instance, GuiGraphics graphics, int x, int y, List<Component> list, int maxWidth, int color) {
        return FontUtilities.drawParagraph(instance, graphics, x, y, list, maxWidth, color, true);
    }

    public static int drawParagraph(Minecraft instance, GuiGraphics graphics, BlitCoordinates pos, List<Component> list, int color) {
        return FontUtilities.drawParagraph(instance, graphics, pos.getX(), pos.getY(), list, pos.getWidth(), color, true);
    }

    public static int drawParagraph(Minecraft instance, GuiGraphics graphics, BlitCoordinates pos, List<Component> list, int color, boolean renderShadow) {
        return FontUtilities.drawParagraph(instance, graphics, pos.getX(), pos.getY(), list, pos.getWidth(), color, renderShadow);
    }

    public static void drawText(Minecraft instance, GuiGraphics graphics, BlitCoordinates pos, Component text, int color) {
        FontUtilities.drawText(instance, graphics, pos, text, color, true);
    }

    public static void drawText(Minecraft instance, GuiGraphics graphics, BlitCoordinates pos, Component text, int color, boolean renderShadow) {
        Objects.requireNonNull(instance.f_91062_);
        pos = pos.withHeight(9).withWidth(instance.f_91062_.m_92852_((FormattedText)text));
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        graphics.m_280614_(instance.f_91062_, text, pos.getX(), pos.getY(), color, renderShadow);
        RenderSystem.enableDepthTest();
    }

    public static boolean drawLink(Minecraft instance, GuiGraphics graphics, BlitCoordinates pos, Component text, int color, int highlightedColor, double mouseX, double mouseY, boolean mouseDown) {
        return FontUtilities.drawLink(instance, graphics, pos, text, color, highlightedColor, true, mouseX, mouseY, mouseDown);
    }

    public static boolean drawLink(Minecraft instance, GuiGraphics graphics, BlitCoordinates pos, Component text, int color, int highlightedColor, boolean renderShadow, double mouseX, double mouseY, boolean mouseDown) {
        int areaWidth = instance.f_91062_.m_92852_((FormattedText)text);
        Objects.requireNonNull(instance.f_91062_);
        int areaHeight = 9;
        boolean highlighted = ScreenUtilities.mouseInArea(mouseX, mouseY, pos.withWidth(areaWidth).withHeight(areaHeight).toRect());
        FontUtilities.drawText(instance, graphics, pos, text, highlighted ? highlightedColor : color, renderShadow);
        return highlighted && mouseDown;
    }

    public static boolean drawLinkWrapped(Minecraft instance, GuiGraphics graphics, BlitCoordinates pos, Component text, int color, int highlightedColor, double mouseX, double mouseY, boolean mouseDown) {
        return FontUtilities.drawLinkWrapped(instance, graphics, pos, text, color, highlightedColor, true, mouseX, mouseY, mouseDown);
    }

    public static boolean drawLinkWrapped(Minecraft instance, GuiGraphics graphics, BlitCoordinates pos, Component text, int color, int highlightedColor, boolean renderShadow, double mouseX, double mouseY, boolean mouseDown) {
        int areaWidth = pos.getWidth();
        int areaHeight = instance.f_91062_.m_239133_((FormattedText)text, areaWidth);
        boolean highlighted = ScreenUtilities.mouseInArea(mouseX, mouseY, pos.withWidth(areaWidth).withHeight(areaHeight).toRect());
        FontUtilities.drawParagraph(instance, graphics, pos, List.of(text), highlighted ? highlightedColor : color, renderShadow);
        return highlighted && mouseDown;
    }
}

